<?php

define( 'naga_cp_min_reqiered_php', '7.4' ); // without dot (not 7.4.0)
define( 'naga_cp_min_reqiered_ioncube', '12' ); // without dot (not 12.0.0)

add_action( 'init', function() {
	load_textdomain( 'naga-cp-notices', plugin_dir_path( __FILE__ ) . 'languages/' . 'naga-cp-notices-fa_IR.mo' );
});

require_once( plugin_dir_path( __FILE__ ) . 'includes/naga-cp-notices.php' );

// Load NagaTheme License, RTL and Persian Files
if( version_compare( PHP_VERSION, naga_cp_min_reqiered_php ) >= 0 ) {
	
	if( extension_loaded( 'ionCube Loader' ) ) {
		
		if( function_exists( 'ioncube_loader_version' ) && version_compare( ioncube_loader_version(), naga_cp_min_reqiered_ioncube ) >= 0 ) {
			
			require_once( plugin_dir_path( __FILE__ ) . 'naga-cp-ic.php' );
			
		} else {
			
			add_action( 'admin_notices', 'naga_cp_ioncube_version_notice' );
			add_action( 'admin_init', 'naga_cp_deactivate_licenses' );
			
		}
			
	} else {
		
		add_action( 'admin_notices', 'naga_cp_ioncube_notice' );
		add_action( 'admin_init', 'naga_cp_deactivate_licenses' );
		
	}
} else {
	
	add_action( 'admin_notices', 'naga_cp_php_notice' );
	add_action( 'admin_init', 'naga_cp_deactivate_licenses' );

}