<?php
/**
 * Countries
 *
 * Returns an array of countries and codes.
 *
 * @package Convert Pro/i18n
 * @version 2.5.0
 */

defined( 'ABSPATH' ) || exit;

/**
 * Function Name: bsf_all_countries.
 * Function Description: bsf_all_countries names and codes.
 *
 * @return array all countries and it's code.
 */
function bsf_all_countries() {
	return array(
		'AF' => __( 'Afghanistan', 'convertpro' ),
		'AX' => __( '&#197;land Islands', 'convertpro' ),
		'AL' => __( 'Albania', 'convertpro' ),
		'DZ' => __( 'Algeria', 'convertpro' ),
		'AS' => __( 'American Samoa', 'convertpro' ),
		'AD' => __( 'Andorra', 'convertpro' ),
		'AO' => __( 'Angola', 'convertpro' ),
		'AI' => __( 'Anguilla', 'convertpro' ),
		'AQ' => __( 'Antarctica', 'convertpro' ),
		'AG' => __( 'Antigua and Barbuda', 'convertpro' ),
		'AR' => __( 'Argentina', 'convertpro' ),
		'AM' => __( 'Armenia', 'convertpro' ),
		'AW' => __( 'Aruba', 'convertpro' ),
		'AU' => __( 'Australia', 'convertpro' ),
		'AT' => __( 'Austria', 'convertpro' ),
		'AZ' => __( 'Azerbaijan', 'convertpro' ),
		'BS' => __( 'Bahamas', 'convertpro' ),
		'BH' => __( 'Bahrain', 'convertpro' ),
		'BD' => __( 'Bangladesh', 'convertpro' ),
		'BB' => __( 'Barbados', 'convertpro' ),
		'BY' => __( 'Belarus', 'convertpro' ),
		'BE' => __( 'Belgium', 'convertpro' ),
		'PW' => __( 'Belau', 'convertpro' ),
		'BZ' => __( 'Belize', 'convertpro' ),
		'BJ' => __( 'Benin', 'convertpro' ),
		'BM' => __( 'Bermuda', 'convertpro' ),
		'BT' => __( 'Bhutan', 'convertpro' ),
		'BO' => __( 'Bolivia', 'convertpro' ),
		'BQ' => __( 'Bonaire, Saint Eustatius and Saba', 'convertpro' ),
		'BA' => __( 'Bosnia and Herzegovina', 'convertpro' ),
		'BW' => __( 'Botswana', 'convertpro' ),
		'BV' => __( 'Bouvet Island', 'convertpro' ),
		'BR' => __( 'Brazil', 'convertpro' ),
		'IO' => __( 'British Indian Ocean Territory', 'convertpro' ),
		'VG' => __( 'British Virgin Islands', 'convertpro' ),
		'BN' => __( 'Brunei', 'convertpro' ),
		'BG' => __( 'Bulgaria', 'convertpro' ),
		'BF' => __( 'Burkina Faso', 'convertpro' ),
		'BI' => __( 'Burundi', 'convertpro' ),
		'KH' => __( 'Cambodia', 'convertpro' ),
		'CM' => __( 'Cameroon', 'convertpro' ),
		'CA' => __( 'Canada', 'convertpro' ),
		'CV' => __( 'Cape Verde', 'convertpro' ),
		'KY' => __( 'Cayman Islands', 'convertpro' ),
		'CF' => __( 'Central African Republic', 'convertpro' ),
		'TD' => __( 'Chad', 'convertpro' ),
		'CL' => __( 'Chile', 'convertpro' ),
		'CN' => __( 'China', 'convertpro' ),
		'CX' => __( 'Christmas Island', 'convertpro' ),
		'CC' => __( 'Cocos (Keeling) Islands', 'convertpro' ),
		'CO' => __( 'Colombia', 'convertpro' ),
		'KM' => __( 'Comoros', 'convertpro' ),
		'CG' => __( 'Congo (Brazzaville)', 'convertpro' ),
		'CD' => __( 'Congo (Kinshasa)', 'convertpro' ),
		'CK' => __( 'Cook Islands', 'convertpro' ),
		'CR' => __( 'Costa Rica', 'convertpro' ),
		'HR' => __( 'Croatia', 'convertpro' ),
		'CU' => __( 'Cuba', 'convertpro' ),
		'CW' => __( 'Cura&ccedil;ao', 'convertpro' ),
		'CY' => __( 'Cyprus', 'convertpro' ),
		'CZ' => __( 'Czech Republic', 'convertpro' ),
		'DK' => __( 'Denmark', 'convertpro' ),
		'DJ' => __( 'Djibouti', 'convertpro' ),
		'DM' => __( 'Dominica', 'convertpro' ),
		'DO' => __( 'Dominican Republic', 'convertpro' ),
		'EC' => __( 'Ecuador', 'convertpro' ),
		'EG' => __( 'Egypt', 'convertpro' ),
		'SV' => __( 'El Salvador', 'convertpro' ),
		'GQ' => __( 'Equatorial Guinea', 'convertpro' ),
		'ER' => __( 'Eritrea', 'convertpro' ),
		'EE' => __( 'Estonia', 'convertpro' ),
		'ET' => __( 'Ethiopia', 'convertpro' ),
		'FK' => __( 'Falkland Islands', 'convertpro' ),
		'FO' => __( 'Faroe Islands', 'convertpro' ),
		'FJ' => __( 'Fiji', 'convertpro' ),
		'FI' => __( 'Finland', 'convertpro' ),
		'FR' => __( 'France', 'convertpro' ),
		'GF' => __( 'French Guiana', 'convertpro' ),
		'PF' => __( 'French Polynesia', 'convertpro' ),
		'TF' => __( 'French Southern Territories', 'convertpro' ),
		'GA' => __( 'Gabon', 'convertpro' ),
		'GM' => __( 'Gambia', 'convertpro' ),
		'GE' => __( 'Georgia', 'convertpro' ),
		'DE' => __( 'Germany', 'convertpro' ),
		'GH' => __( 'Ghana', 'convertpro' ),
		'GI' => __( 'Gibraltar', 'convertpro' ),
		'GR' => __( 'Greece', 'convertpro' ),
		'GL' => __( 'Greenland', 'convertpro' ),
		'GD' => __( 'Grenada', 'convertpro' ),
		'GP' => __( 'Guadeloupe', 'convertpro' ),
		'GU' => __( 'Guam', 'convertpro' ),
		'GT' => __( 'Guatemala', 'convertpro' ),
		'GG' => __( 'Guernsey', 'convertpro' ),
		'GN' => __( 'Guinea', 'convertpro' ),
		'GW' => __( 'Guinea-Bissau', 'convertpro' ),
		'GY' => __( 'Guyana', 'convertpro' ),
		'HT' => __( 'Haiti', 'convertpro' ),
		'HM' => __( 'Heard Island and McDonald Islands', 'convertpro' ),
		'HN' => __( 'Honduras', 'convertpro' ),
		'HK' => __( 'Hong Kong', 'convertpro' ),
		'HU' => __( 'Hungary', 'convertpro' ),
		'IS' => __( 'Iceland', 'convertpro' ),
		'IN' => __( 'India', 'convertpro' ),
		'ID' => __( 'Indonesia', 'convertpro' ),
		'IR' => __( 'Iran', 'convertpro' ),
		'IQ' => __( 'Iraq', 'convertpro' ),
		'IE' => __( 'Ireland', 'convertpro' ),
		'IM' => __( 'Isle of Man', 'convertpro' ),
		'IL' => __( 'Israel', 'convertpro' ),
		'IT' => __( 'Italy', 'convertpro' ),
		'CI' => __( 'Ivory Coast', 'convertpro' ),
		'JM' => __( 'Jamaica', 'convertpro' ),
		'JP' => __( 'Japan', 'convertpro' ),
		'JE' => __( 'Jersey', 'convertpro' ),
		'JO' => __( 'Jordan', 'convertpro' ),
		'KZ' => __( 'Kazakhstan', 'convertpro' ),
		'KE' => __( 'Kenya', 'convertpro' ),
		'KI' => __( 'Kiribati', 'convertpro' ),
		'KW' => __( 'Kuwait', 'convertpro' ),
		'KG' => __( 'Kyrgyzstan', 'convertpro' ),
		'LA' => __( 'Laos', 'convertpro' ),
		'LV' => __( 'Latvia', 'convertpro' ),
		'LB' => __( 'Lebanon', 'convertpro' ),
		'LS' => __( 'Lesotho', 'convertpro' ),
		'LR' => __( 'Liberia', 'convertpro' ),
		'LY' => __( 'Libya', 'convertpro' ),
		'LI' => __( 'Liechtenstein', 'convertpro' ),
		'LT' => __( 'Lithuania', 'convertpro' ),
		'LU' => __( 'Luxembourg', 'convertpro' ),
		'MO' => __( 'Macao S.A.R., China', 'convertpro' ),
		'MK' => __( 'Macedonia', 'convertpro' ),
		'MG' => __( 'Madagascar', 'convertpro' ),
		'MW' => __( 'Malawi', 'convertpro' ),
		'MY' => __( 'Malaysia', 'convertpro' ),
		'MV' => __( 'Maldives', 'convertpro' ),
		'ML' => __( 'Mali', 'convertpro' ),
		'MT' => __( 'Malta', 'convertpro' ),
		'MH' => __( 'Marshall Islands', 'convertpro' ),
		'MQ' => __( 'Martinique', 'convertpro' ),
		'MR' => __( 'Mauritania', 'convertpro' ),
		'MU' => __( 'Mauritius', 'convertpro' ),
		'YT' => __( 'Mayotte', 'convertpro' ),
		'MX' => __( 'Mexico', 'convertpro' ),
		'FM' => __( 'Micronesia', 'convertpro' ),
		'MD' => __( 'Moldova', 'convertpro' ),
		'MC' => __( 'Monaco', 'convertpro' ),
		'MN' => __( 'Mongolia', 'convertpro' ),
		'ME' => __( 'Montenegro', 'convertpro' ),
		'MS' => __( 'Montserrat', 'convertpro' ),
		'MA' => __( 'Morocco', 'convertpro' ),
		'MZ' => __( 'Mozambique', 'convertpro' ),
		'MM' => __( 'Myanmar', 'convertpro' ),
		'NA' => __( 'Namibia', 'convertpro' ),
		'NR' => __( 'Nauru', 'convertpro' ),
		'NP' => __( 'Nepal', 'convertpro' ),
		'NL' => __( 'Netherlands', 'convertpro' ),
		'NC' => __( 'New Caledonia', 'convertpro' ),
		'NZ' => __( 'New Zealand', 'convertpro' ),
		'NI' => __( 'Nicaragua', 'convertpro' ),
		'NE' => __( 'Niger', 'convertpro' ),
		'NG' => __( 'Nigeria', 'convertpro' ),
		'NU' => __( 'Niue', 'convertpro' ),
		'NF' => __( 'Norfolk Island', 'convertpro' ),
		'MP' => __( 'Northern Mariana Islands', 'convertpro' ),
		'KP' => __( 'North Korea', 'convertpro' ),
		'NO' => __( 'Norway', 'convertpro' ),
		'OM' => __( 'Oman', 'convertpro' ),
		'PK' => __( 'Pakistan', 'convertpro' ),
		'PS' => __( 'Palestinian Territory', 'convertpro' ),
		'PA' => __( 'Panama', 'convertpro' ),
		'PG' => __( 'Papua New Guinea', 'convertpro' ),
		'PY' => __( 'Paraguay', 'convertpro' ),
		'PE' => __( 'Peru', 'convertpro' ),
		'PH' => __( 'Philippines', 'convertpro' ),
		'PN' => __( 'Pitcairn', 'convertpro' ),
		'PL' => __( 'Poland', 'convertpro' ),
		'PT' => __( 'Portugal', 'convertpro' ),
		'PR' => __( 'Puerto Rico', 'convertpro' ),
		'QA' => __( 'Qatar', 'convertpro' ),
		'RE' => __( 'Reunion', 'convertpro' ),
		'RO' => __( 'Romania', 'convertpro' ),
		'RU' => __( 'Russia', 'convertpro' ),
		'RW' => __( 'Rwanda', 'convertpro' ),
		'BL' => __( 'Saint Barth&eacute;lemy', 'convertpro' ),
		'SH' => __( 'Saint Helena', 'convertpro' ),
		'KN' => __( 'Saint Kitts and Nevis', 'convertpro' ),
		'LC' => __( 'Saint Lucia', 'convertpro' ),
		'MF' => __( 'Saint Martin (French part)', 'convertpro' ),
		'SX' => __( 'Saint Martin (Dutch part)', 'convertpro' ),
		'PM' => __( 'Saint Pierre and Miquelon', 'convertpro' ),
		'VC' => __( 'Saint Vincent and the Grenadines', 'convertpro' ),
		'SM' => __( 'San Marino', 'convertpro' ),
		'ST' => __( 'S&atilde;o Tom&eacute; and Pr&iacute;ncipe', 'convertpro' ),
		'SA' => __( 'Saudi Arabia', 'convertpro' ),
		'SN' => __( 'Senegal', 'convertpro' ),
		'RS' => __( 'Serbia', 'convertpro' ),
		'SC' => __( 'Seychelles', 'convertpro' ),
		'SL' => __( 'Sierra Leone', 'convertpro' ),
		'SG' => __( 'Singapore', 'convertpro' ),
		'SK' => __( 'Slovakia', 'convertpro' ),
		'SI' => __( 'Slovenia', 'convertpro' ),
		'SB' => __( 'Solomon Islands', 'convertpro' ),
		'SO' => __( 'Somalia', 'convertpro' ),
		'ZA' => __( 'South Africa', 'convertpro' ),
		'GS' => __( 'South Georgia/Sandwich Islands', 'convertpro' ),
		'KR' => __( 'South Korea', 'convertpro' ),
		'SS' => __( 'South Sudan', 'convertpro' ),
		'ES' => __( 'Spain', 'convertpro' ),
		'LK' => __( 'Sri Lanka', 'convertpro' ),
		'SD' => __( 'Sudan', 'convertpro' ),
		'SR' => __( 'Suriname', 'convertpro' ),
		'SJ' => __( 'Svalbard and Jan Mayen', 'convertpro' ),
		'SZ' => __( 'Swaziland', 'convertpro' ),
		'SE' => __( 'Sweden', 'convertpro' ),
		'CH' => __( 'Switzerland', 'convertpro' ),
		'SY' => __( 'Syria', 'convertpro' ),
		'TW' => __( 'Taiwan', 'convertpro' ),
		'TJ' => __( 'Tajikistan', 'convertpro' ),
		'TZ' => __( 'Tanzania', 'convertpro' ),
		'TH' => __( 'Thailand', 'convertpro' ),
		'TL' => __( 'Timor-Leste', 'convertpro' ),
		'TG' => __( 'Togo', 'convertpro' ),
		'TK' => __( 'Tokelau', 'convertpro' ),
		'TO' => __( 'Tonga', 'convertpro' ),
		'TT' => __( 'Trinidad and Tobago', 'convertpro' ),
		'TN' => __( 'Tunisia', 'convertpro' ),
		'TR' => __( 'Turkey', 'convertpro' ),
		'TM' => __( 'Turkmenistan', 'convertpro' ),
		'TC' => __( 'Turks and Caicos Islands', 'convertpro' ),
		'TV' => __( 'Tuvalu', 'convertpro' ),
		'UG' => __( 'Uganda', 'convertpro' ),
		'UA' => __( 'Ukraine', 'convertpro' ),
		'AE' => __( 'United Arab Emirates', 'convertpro' ),
		'GB' => __( 'United Kingdom (UK)', 'convertpro' ),
		'US' => __( 'United States (US)', 'convertpro' ),
		'UM' => __( 'United States (US) Minor Outlying Islands', 'convertpro' ),
		'VI' => __( 'United States (US) Virgin Islands', 'convertpro' ),
		'UY' => __( 'Uruguay', 'convertpro' ),
		'UZ' => __( 'Uzbekistan', 'convertpro' ),
		'VU' => __( 'Vanuatu', 'convertpro' ),
		'VA' => __( 'Vatican', 'convertpro' ),
		'VE' => __( 'Venezuela', 'convertpro' ),
		'VN' => __( 'Vietnam', 'convertpro' ),
		'WF' => __( 'Wallis and Futuna', 'convertpro' ),
		'EH' => __( 'Western Sahara', 'convertpro' ),
		'WS' => __( 'Samoa', 'convertpro' ),
		'YE' => __( 'Yemen', 'convertpro' ),
		'ZM' => __( 'Zambia', 'convertpro' ),
		'ZW' => __( 'Zimbabwe', 'convertpro' ),
	);
}

/**
 * Function Name: bsf_eu_countries.
 * Function Description: bsf_eu_countries european country names and codes.
 *
 * @return array eauropean all countries and it's code.
 */
function bsf_eu_countries() {
	return array(
		'AL' => __( 'Albania', 'convertpro' ),
		'AD' => __( 'Andorra', 'convertpro' ),
		'AM' => __( 'Armenia', 'convertpro' ),
		'AT' => __( 'Austria', 'convertpro' ),
		'AZ' => __( 'Azerbaijan', 'convertpro' ),
		'BY' => __( 'Belarus', 'convertpro' ),
		'BE' => __( 'Belgium', 'convertpro' ),
		'BA' => __( 'Bosnia and Herzegovina', 'convertpro' ),
		'BG' => __( 'Bulgaria', 'convertpro' ),
		'HR' => __( 'Croatia', 'convertpro' ),
		'CY' => __( 'Cyprus', 'convertpro' ),
		'CZ' => __( 'Czech Republic', 'convertpro' ),
		'DK' => __( 'Denmark', 'convertpro' ),
		'EE' => __( 'Estonia', 'convertpro' ),
		'FI' => __( 'Finland', 'convertpro' ),
		'FR' => __( 'France', 'convertpro' ),
		'GE' => __( 'Georgia', 'convertpro' ),
		'DE' => __( 'Germany', 'convertpro' ),
		'GR' => __( 'Greece', 'convertpro' ),
		'HU' => __( 'Hungary', 'convertpro' ),
		'IS' => __( 'Iceland', 'convertpro' ),
		'IE' => __( 'Ireland', 'convertpro' ),
		'IT' => __( 'Italy', 'convertpro' ),
		'KZ' => __( 'Kazakhstan', 'convertpro' ),
		'LV' => __( 'Latvia', 'convertpro' ),
		'LI' => __( 'Liechtenstein', 'convertpro' ),
		'LT' => __( 'Lithuania', 'convertpro' ),
		'LU' => __( 'Luxembourg', 'convertpro' ),
		'MK' => __( 'Macedonia', 'convertpro' ),
		'MT' => __( 'Malta', 'convertpro' ),
		'MD' => __( 'Moldova', 'convertpro' ),
		'MC' => __( 'Monaco', 'convertpro' ),
		'ME' => __( 'Montenegro', 'convertpro' ),
		'NL' => __( 'Netherlands', 'convertpro' ),
		'NO' => __( 'Norway', 'convertpro' ),
		'PL' => __( 'Poland', 'convertpro' ),
		'PT' => __( 'Portugal', 'convertpro' ),
		'RO' => __( 'Romania', 'convertpro' ),
		'RU' => __( 'Russia', 'convertpro' ),
		'SM' => __( 'San Marino', 'convertpro' ),
		'RS' => __( 'Serbia', 'convertpro' ),
		'SK' => __( 'Slovakia', 'convertpro' ),
		'SI' => __( 'Slovenia', 'convertpro' ),
		'ES' => __( 'Spain', 'convertpro' ),
		'SE' => __( 'Sweden', 'convertpro' ),
		'CH' => __( 'Switzerland', 'convertpro' ),
		'TR' => __( 'Turkey', 'convertpro' ),
		'UA' => __( 'Ukraine', 'convertpro' ),
		'GB' => __( 'United Kingdom (UK)', 'convertpro' ),
		'VA' => __( 'Vatican', 'convertpro' ),
	);
}
