jQuery(document).ready(function(){
  
  var input  = jQuery(".cp-background");
  var name = jQuery(".cp-background").attr("id");
  var parent = input.closest(".cp-element-container");

  var bg_repeat = parent.find("#"+name+"_rpt");
  var bg_pos = parent.find("#"+name+"_pos");
  var bg_size = parent.find("#"+name+"_size");
  var css_preview = input.attr('data-css-preview') || '';
  var selector    = input.attr('data-css-selector') || '';
  var property    = input.attr('data-css-property') || '';

  var value = "";
  value = bg_repeat.val()+"|"+bg_pos.val()+"|"+bg_size.val();
  input.val(value);

  bg_repeat.on( "change", function(){
    value = jQuery(this).val()+"|"+bg_pos.val()+"|"+bg_size.val();
    input.val(value);
    input.trigger('change');
    jQuery(document).trigger('cp-bg-opt-change', [ name, value , 'background-opt',selector] );
  });
  bg_pos.on( "change", function(){
    value = bg_repeat.val()+"|"+jQuery(this).val()+"|"+bg_size.val();
    input.val(value);
    input.trigger('change');
    jQuery(document).trigger('cp-bg-opt-change', [ name, value , 'background-opt',selector] );
  });
  bg_size.on( "change", function(){
    value = bg_repeat.val()+"|"+bg_pos.val()+"|"+jQuery(this).val();
    input.val(value);
    input.trigger('change');
    jQuery(document).trigger('cp-bg-opt-change', [ name, value , 'background-opt',selector] );
  });

  /* Background image dependency handled here */

 var image_url = parent.siblings("[data-value='upload_img']").find(".cp-media").val();
  var container_option = parent.siblings("[data-value='upload_img']").find(".cp-media").attr("name");
  var src_option = container_option + "_src";
  var src_element = jQuery('select[name=' + src_option + ']');
  var img_src = jQuery('select[name=' + src_option + ']').val();

  if( image_url == '' ) {
    setTimeout(function() {
      parent.hide();
    }, 400);
  }

  src_element.on( "change", function() {
    var src_img = jQuery(this).val();
    if( src_img !== 'upload_img' ) {
      parent.hide();
    } else {
      image_url = parent.siblings("[data-value='upload_img']").find(".cp-media").val();
      if( image_url == '' ) {
        parent.hide();
      } else {
        parent.show();
      }
    }
  });

  jQuery(document).on( "cp-image-change", function(e, name, url, val) {
    if( name == container_option ) {
      if( url !== '' ) {
        parent.show();
      }
    }
  });

});