<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

// Hide Activation Admin Notices
$nagatheme = get_option( 'brainstrom_products' );
$nagatheme['plugins']['convertpro']['status'] = 'registered';
update_option( 'brainstrom_products', $nagatheme );

// Copy Translations As String Content --- Convert Pro & Convert Pro Addons
add_action( 'admin_init', 'convert_pro_naga_copy_contrans' );
function convert_pro_naga_copy_contrans() {
	if ( is_rtl() ) {
		$locale = 'fa_IR';
		$domains = array ('convertpro', 'convertpro-addon');
		foreach ( $domains as $domain ) {
			$mofile = $domain . '-' . $locale . '.mo';
			$file1 = plugin_dir_path( __FILE__ ) . 'languages/' . $mofile;
			$file2 = WP_LANG_DIR . '/plugins/' . $mofile;
			$contentx =@ file_get_contents( $file1 );
			$openedfile = fopen( $file2, "w" );
			fwrite( $openedfile, $contentx ) ;
			fclose( $openedfile );
			if ( $contentx === FALSE ) {
				$status = false;
			} else {
				$status = true;
			}
			//var_dump("Text-Domain: $domain - Status: $status");
		}
	}
}

// Custom Admin CSS Styles
add_action( 'admin_enqueue_scripts', 'convertpro_naga_admin_css' );
function convertpro_naga_admin_css() {
	if ( is_rtl() ) {
		wp_enqueue_style( 'convertpro-naga-admin-css', plugin_dir_url( __FILE__ ) . 'css/convertpro-naga-admin.css' );
	}
}

// Custom Front-End CSS Styles
add_action( 'wp_enqueue_scripts', 'convertpro_naga_front_css' );
function convertpro_naga_front_css() {
	if ( is_rtl() ) {
		wp_enqueue_style( 'convertpro-naga-front-css', plugin_dir_url( __FILE__ ) . 'css/convertpro-naga-front.css' );
	}
}